/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IParent;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.viewsupport.AsnElementImageProvider;
import org.asnlab.asndt.ui.AsnElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AsnWorkbenchAdapter
implements IWorkbenchAdapter {
    protected static final Object[] NO_CHILDREN = new Object[0];
    private AsnElementImageProvider fImageProvider = new AsnElementImageProvider();

    public Object[] getChildren(Object element) {
        IAsnElement je = this.getAsnElement(element);
        if (je instanceof IParent) {
            try {
                return ((IParent)je).getChildren();
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e);
            }
        }
        return NO_CHILDREN;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IAsnElement je = this.getAsnElement(element);
        if (je != null) {
            return this.fImageProvider.getAsnImageDescriptor(je, 3);
        }
        return null;
    }

    public String getLabel(Object element) {
        return AsnElementLabels.getTextLabel(this.getAsnElement(element));
    }

    public Object getParent(Object element) {
        IAsnElement je = this.getAsnElement(element);
        return je != null ? je.getParent() : null;
    }

    private IAsnElement getAsnElement(Object element) {
        if (element instanceof IAsnElement) {
            return (IAsnElement)element;
        }
        return null;
    }
}

