/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.input.DemuxInputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class FilenameUtils {
    private static final /* synthetic */ char UNIX_SEPARATOR = '/';
    private static final /* synthetic */ char SYSTEM_SEPARATOR;
    private static final /* synthetic */ char OTHER_SEPARATOR;
    private static final /* synthetic */ char EXTENSION_SEPARATOR = '.';
    private static final /* synthetic */ char WINDOWS_SEPARATOR = '\\';

    public static boolean isExtension(String a2, String a3) {
        if (a2 == null) {
            return false;
        }
        if (a3 == null || a3.length() == 0) {
            return FilenameUtils.indexOfExtension(a2) == -1;
        }
        return FilenameUtils.getExtension(a2).equals(a3);
    }

    public static String separatorsToWindows(String a2) {
        if (a2 == null || a2.indexOf(47) == -1) {
            return a2;
        }
        return a2.replace('/', '\\');
    }

    public static String separatorsToSystem(String a2) {
        if (a2 == null) {
            return null;
        }
        if (FilenameUtils.isSystemWindows()) {
            return FilenameUtils.separatorsToWindows(a2);
        }
        return FilenameUtils.separatorsToUnix(a2);
    }

    public static String concat(String a2, String a3) {
        int n2 = FilenameUtils.getPrefixLength(a3);
        if (n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            return FilenameUtils.normalize(a3);
        }
        if (a2 == null) {
            return null;
        }
        n2 = a2.length();
        if (n2 == 0) {
            return FilenameUtils.normalize(a3);
        }
        if (FilenameUtils.isSeparator(a2.charAt(n2 - 1))) {
            return FilenameUtils.normalize(new StringBuffer().insert(0, a2).append(a3).toString());
        }
        return FilenameUtils.normalize(new StringBuffer().insert(0, a2).append('/').append(a3).toString());
    }

    private static /* synthetic */ String doNormalize(String a2, boolean a3) {
        int n2;
        int n3;
        if (a2 == null) {
            return null;
        }
        int n4 = a2.length();
        if (n4 == 0) {
            return a2;
        }
        int n5 = FilenameUtils.getPrefixLength(a2);
        if (n5 < 0) {
            return null;
        }
        char[] cArray = new char[n4 + 2];
        String string = a2;
        string.getChars(0, string.length(), cArray, 0);
        int n6 = n3 = 0;
        while (n6 < cArray.length) {
            if (cArray[n3] == OTHER_SEPARATOR) {
                cArray[n3] = SYSTEM_SEPARATOR;
            }
            n6 = ++n3;
        }
        n3 = 1;
        if (cArray[n4 - 1] != SYSTEM_SEPARATOR) {
            cArray[n4++] = SYSTEM_SEPARATOR;
            n3 = 0;
        }
        int n7 = n2 = n5 + 1;
        while (n7 < n4) {
            if (cArray[n2] == SYSTEM_SEPARATOR && cArray[n2 - 1] == SYSTEM_SEPARATOR) {
                System.arraycopy(cArray, n2, cArray, n2 - 1, n4-- - n2);
                --n2;
            }
            n7 = ++n2;
        }
        int n8 = n2 = n5 + 1;
        while (n8 < n4) {
            if (cArray[n2] == SYSTEM_SEPARATOR && cArray[n2 - 1] == '.' && (n2 == n5 + 1 || cArray[n2 - 2] == SYSTEM_SEPARATOR)) {
                if (n2 == n4 - 1) {
                    n3 = 1;
                }
                int n9 = n4;
                n4 -= 2;
                System.arraycopy(cArray, n2 + 1, cArray, n2 - 1, n9 - n2);
                --n2;
            }
            n8 = ++n2;
        }
        int n10 = n2 = n5 + 2;
        while (n10 < n4) {
            block20: {
                if (cArray[n2] == SYSTEM_SEPARATOR && cArray[n2 - 1] == '.' && cArray[n2 - 2] == '.' && (n2 == n5 + 2 || cArray[n2 - 3] == SYSTEM_SEPARATOR)) {
                    if (n2 == n5 + 2) {
                        return null;
                    }
                    if (n2 == n4 - 1) {
                        n3 = 1;
                    }
                    int n11 = n2 - 4;
                    while (n11 >= n5) {
                        int n12;
                        if (cArray[n12] == SYSTEM_SEPARATOR) {
                            System.arraycopy(cArray, n2 + 1, cArray, n12 + 1, n4 - n2);
                            n4 -= n2 - n12;
                            n2 = n12 + 1;
                            break block20;
                        }
                        n11 = --n12;
                    }
                    System.arraycopy(cArray, n2 + 1, cArray, n5, n4 - n2);
                    n4 -= n2 + 1 - n5;
                    n2 = n5 + 1;
                }
            }
            n10 = ++n2;
        }
        if (n4 <= 0) {
            return "";
        }
        if (n4 <= n5) {
            return new String(cArray, 0, n4);
        }
        if (n3 != 0 && a3) {
            return new String(cArray, 0, n4);
        }
        return new String(cArray, 0, n4 - 1);
    }

    public static int indexOfExtension(String a2) {
        if (a2 == null) {
            return -1;
        }
        String string = a2;
        int n2 = string.lastIndexOf(46);
        if (FilenameUtils.indexOfLastSeparator(string) > n2) {
            return -1;
        }
        return n2;
    }

    public FilenameUtils() {
        FilenameUtils a2;
    }

    public static String getPathNoEndSeparator(String a2) {
        return FilenameUtils.doGetPath(a2, 0);
    }

    public static boolean equals(String a2, String a3) {
        return FilenameUtils.equals(a2, a3, false, IOCase.SENSITIVE);
    }

    public static String getExtension(String a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(a2);
        if (n2 == -1) {
            return "";
        }
        return a2.substring(n2 + 1);
    }

    public static String removeExtension(String a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(a2);
        if (n2 == -1) {
            return a2;
        }
        return a2.substring(0, n2);
    }

    public static String getPath(String a2) {
        return FilenameUtils.doGetPath(a2, 1);
    }

    public static String getFullPathNoEndSeparator(String a2) {
        return FilenameUtils.doGetFullPath(a2, false);
    }

    public static boolean isExtension(String a2, String[] a3) {
        int n2;
        if (a2 == null) {
            return false;
        }
        if (a3 == null || a3.length == 0) {
            return FilenameUtils.indexOfExtension(a2) == -1;
        }
        String string = FilenameUtils.getExtension(a2);
        int n3 = n2 = 0;
        while (n3 < a3.length) {
            if (string.equals(a3[n2])) {
                return true;
            }
            n3 = ++n2;
        }
        return false;
    }

    public static boolean equals(String a2, String a3, boolean a4, IOCase a5) {
        if (a2 == null || a3 == null) {
            return a2 == a3;
        }
        if (a4) {
            a2 = FilenameUtils.normalize(a2);
            a3 = FilenameUtils.normalize(a3);
        }
        if (a5 == null) {
            a5 = IOCase.SENSITIVE;
        }
        return a5.checkEquals(a2, a3);
    }

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static /* synthetic */ boolean isSeparator(char a2) {
        return a2 == '/' || a2 == '\\';
    }

    public static String getFullPath(String a2) {
        return FilenameUtils.doGetFullPath(a2, true);
    }

    public static String normalize(String a2) {
        return FilenameUtils.doNormalize(a2, true);
    }

    public static String getPrefix(String a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(a2);
        if (n2 < 0) {
            return null;
        }
        if (n2 > a2.length()) {
            return new StringBuffer().insert(0, a2).append('/').toString();
        }
        return a2.substring(0, n2);
    }

    public static String normalizeNoEndSeparator(String a2) {
        return FilenameUtils.doNormalize(a2, false);
    }

    static String[] splitOnTokens(String a2) {
        int n2;
        if (a2.indexOf(DemuxInputStream.K("u")) == -1 && a2.indexOf(ProxyInputStream.K("#")) == -1) {
            String[] stringArray = new String[1];
            stringArray[0] = a2;
            return stringArray;
        }
        char[] cArray = a2.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 = 0;
        while (n3 < cArray.length) {
            block8: {
                block6: {
                    block9: {
                        block7: {
                            if (cArray[n2] != '?' && cArray[n2] != '*') break block6;
                            if (stringBuffer.length() != 0) {
                                arrayList.add(stringBuffer.toString());
                                stringBuffer.setLength(0);
                            }
                            if (cArray[n2] != '?') break block7;
                            arrayList.add(DemuxInputStream.K("u"));
                            break block8;
                        }
                        if (arrayList.size() == 0) break block9;
                        if (n2 <= 0) break block8;
                        ArrayList<String> arrayList2 = arrayList;
                        if (arrayList2.get(arrayList2.size() - 1).equals(ProxyInputStream.K("#"))) break block8;
                    }
                    arrayList.add(DemuxInputStream.K("`"));
                    break block8;
                }
                stringBuffer.append(cArray[n2]);
            }
            n3 = ++n2;
        }
        if (stringBuffer.length() != 0) {
            arrayList.add(stringBuffer.toString());
        }
        ArrayList<String> arrayList3 = arrayList;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    private static /* synthetic */ String doGetFullPath(String a2, boolean a32) {
        if (a2 == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(a2);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= a2.length()) {
            if (a32) {
                return FilenameUtils.getPrefix(a2);
            }
            return a2;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(a2);
        if (n3 < 0) {
            return a2.substring(0, n2);
        }
        int a32 = n3 + (a32 ? 1 : 0);
        return a2.substring(0, a32);
    }

    static {
        SYSTEM_SEPARATOR = File.separatorChar;
        OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;
    }

    public static boolean isExtension(String a2, Collection a3) {
        if (a2 == null) {
            return false;
        }
        if (a3 == null || a3.isEmpty()) {
            return FilenameUtils.indexOfExtension(a2) == -1;
        }
        String string = FilenameUtils.getExtension(a2);
        Object object = a3 = a3.iterator();
        while (object.hasNext()) {
            if (string.equals(a3.next())) {
                return true;
            }
            object = a3;
        }
        return false;
    }

    private static /* synthetic */ String doGetPath(String a2, int a3) {
        if (a2 == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(a2);
        if (n2 < 0) {
            return null;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(a2);
        if (n2 >= a2.length() || n3 < 0) {
            return "";
        }
        return a2.substring(n2, n3 + a3);
    }

    public static int getPrefixLength(String a2) {
        if (a2 == null) {
            return -1;
        }
        int n2 = a2.length();
        if (n2 == 0) {
            return 0;
        }
        char c2 = a2.charAt(0);
        if (c2 == ':') {
            return -1;
        }
        if (n2 == 1) {
            if (c2 == '~') {
                return 2;
            }
            if (FilenameUtils.isSeparator(c2)) {
                return 1;
            }
            return 0;
        }
        if (c2 == '~') {
            String string = a2;
            int n3 = string.indexOf(47, 1);
            int n4 = string.indexOf(92, 1);
            if (n3 == -1 && n4 == -1) {
                return n2 + 1;
            }
            n3 = n3 == -1 ? n4 : n3;
            n4 = n4 == -1 ? n3 : n4;
            return Math.min(n3, n4) + 1;
        }
        char c3 = a2.charAt(1);
        if (c3 == ':') {
            if ((c2 = Character.toUpperCase(c2)) >= 'A' && c2 <= 'Z') {
                if (n2 == 2 || !FilenameUtils.isSeparator(a2.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator(c2) && FilenameUtils.isSeparator(c3)) {
            String string = a2;
            int n5 = string.indexOf(47, 2);
            n2 = string.indexOf(92, 2);
            if (n5 == -1 && n2 == -1 || n5 == 2 || n2 == 2) {
                return -1;
            }
            n5 = n5 == -1 ? n2 : n5;
            n2 = n2 == -1 ? n5 : n2;
            return Math.min(n5, n2) + 1;
        }
        if (FilenameUtils.isSeparator(c2)) {
            return 1;
        }
        return 0;
    }

    public static boolean equalsOnSystem(String a2, String a3) {
        return FilenameUtils.equals(a2, a3, false, IOCase.SYSTEM);
    }

    public static boolean wildcardMatchOnSystem(String a2, String a3) {
        return FilenameUtils.wildcardMatch(a2, a3, IOCase.SYSTEM);
    }

    public static int indexOfLastSeparator(String a2) {
        if (a2 == null) {
            return -1;
        }
        String string = a2;
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static String getName(String a2) {
        if (a2 == null) {
            return null;
        }
        String string = a2;
        return string.substring(FilenameUtils.indexOfLastSeparator(string) + 1);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static boolean wildcardMatch(String a2, String a3, IOCase a42) {
        if (a2 == null && a3 == null) {
            return true;
        }
        if (a2 == null || a3 == null) {
            return false;
        }
        if (a42 == null) {
            a42 = IOCase.SENSITIVE;
        }
        IOCase iOCase = a42;
        a2 = iOCase.convertCase(a2);
        a3 = iOCase.convertCase((String)a3);
        a3 = FilenameUtils.splitOnTokens((String)a3);
        boolean a42 = false;
        int n2 = 0;
        int n3 = 0;
        Stack<int[]> stack = new Stack<int[]>();
        do {
            int n4;
            block17: {
                int n5;
                if (stack.size() <= 0) {
                    n5 = ++n3;
                } else {
                    int[] nArray = (int[])stack.pop();
                    n3 = nArray[0];
                    n2 = nArray[1];
                    a42 = true;
                    n5 = n3;
                }
                while (n5 < ((String[])a3).length) {
                    if (a3[n3].equals(ProxyInputStream.K("6"))) {
                        a42 = false;
                        ++n2;
                    } else if (a3[n3].equals(DemuxInputStream.K("`"))) {
                        a42 = true;
                        if (n3 == ((String[])a3).length - 1) {
                            n2 = a2.length();
                        }
                    } else {
                        if (a42) {
                            if ((n2 = a2.indexOf(a3[n3], n2)) == -1) {
                                n4 = n3;
                                break block17;
                            }
                            int n6 = a2.indexOf(a3[n3], n2 + 1);
                            if (n6 >= 0) {
                                int[] nArray = new int[2];
                                nArray[0] = n3;
                                nArray[1] = n6;
                                stack.push(nArray);
                            }
                        } else if (!a2.startsWith(a3[n3], n2)) {
                            n4 = n3;
                            break block17;
                        }
                        n2 += a3[n3].length();
                        a42 = false;
                    }
                    n5 = ++n3;
                }
                n4 = n3;
            }
            if (n4 != ((String[])a3).length || n2 != a2.length()) continue;
            return true;
        } while (stack.size() > 0);
        return false;
    }

    public static String getBaseName(String a2) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(a2));
    }

    public static boolean wildcardMatch(String a2, String a3) {
        return FilenameUtils.wildcardMatch(a2, a3, IOCase.SENSITIVE);
    }

    public static String separatorsToUnix(String a2) {
        if (a2 == null || a2.indexOf(92) == -1) {
            return a2;
        }
        return a2.replace('\\', '/');
    }

    public static boolean equalsNormalized(String a2, String a3) {
        return FilenameUtils.equals(a2, a3, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String a2, String a3) {
        return FilenameUtils.equals(a2, a3, true, IOCase.SYSTEM);
    }
}

