/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences.formatter;

import java.util.Map;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnSourceViewer;
import org.asnlab.asndt.internal.ui.text.SimpleAsnSourceViewerConfiguration;
import org.asnlab.asndt.ui.text.AsnTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public abstract class AsnPreview {
    protected final SimpleAsnSourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    protected Map fWorkingValues;
    private int fTabSize = 0;

    public AsnPreview(Map workingValues, Composite parent) {
        AsnTextTools tools = AsnPlugin.getDefault().getAsnTextTools();
        this.fPreviewDocument = new Document();
        this.fWorkingValues = workingValues;
        tools.setupAsnDocumentPartitioner((IDocument)this.fPreviewDocument, "___asn_partitioning");
        PreferenceStore prioritizedSettings = new PreferenceStore();
        prioritizedSettings.setValue("org.asnlab.asndt.core.compiler.problem.assertIdentifier", "error");
        IPreferenceStore[] chain = new IPreferenceStore[]{prioritizedSettings, AsnPlugin.getDefault().getCombinedPreferenceStore()};
        this.fPreferenceStore = new ChainedPreferenceStore(chain);
        this.fSourceViewer = new AsnSourceViewer(parent, null, null, false, 2824, this.fPreferenceStore);
        this.fViewerConfiguration = new SimpleAsnSourceViewerConfiguration(tools.getColorManager(), this.fPreferenceStore, null, "___asn_partitioning", true);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.asnlab.asndt.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(tools.getColorManager().getColor(rgb));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new AsnSourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        String value = (String)this.fWorkingValues.get("org.asnlab.asndt.core.formatter.lineSplit");
        int lineWidth = AsnPreview.getPositiveIntValue(value, 0);
        this.fMarginPainter.setMarginRulerColumn(lineWidth);
        int tabSize = AsnPreview.getPositiveIntValue((String)this.fWorkingValues.get("org.asnlab.asndt.core.formatter.tabulation.size"), 0);
        if (tabSize != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(tabSize);
        }
        this.fTabSize = tabSize;
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public final Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public final void setWorkingValues(Map workingValues) {
        this.fWorkingValues = workingValues;
    }

    private final class AsnSourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.asnlab.asndt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.asnlab.asndt.ui.editors.textfont");
                    ((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fSourceViewer.getTextWidget().setFont(font);
                    if (((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fMarginPainter != null) {
                        ((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fViewerConfiguration.affectsTextPresentation(event)) {
                    ((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fViewerConfiguration.handlePropertyChangeEvent(event);
                    ((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fSourceViewer.invalidateTextPresentation();
                }
            }
        };

        public AsnSourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            AsnPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            AsnPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener(AsnSourcePreviewerUpdater.this.fontListener);
                    ((AsnSourcePreviewerUpdater)AsnSourcePreviewerUpdater.this).AsnPreview.this.fPreferenceStore.removePropertyChangeListener(AsnSourcePreviewerUpdater.this.propertyListener);
                }
            });
        }
    }
}

